function [x,p]=mvnrndT(mu, cov, vLower, vUpper, debug)
%	MVNRNDT - [x,p]=mvnrndT(mu, cov, vLower, vUpper, debug)
if nargin<5;
   debug = logical(0);
end;
[f,p] = chol(cov);
if debug
   disp('mvnrndT');
   mu
   cov
   p
   f
end
if p>0;
	x=0;
   return;
end;
f = f';
[n,m]=size(mu);
eta = zeros(n,1);
for k=1:n
   if debug
      k
   end
   
   etasum=0;
   if (k>1) 
      for j=1:(k-1)
         etasum = etasum + f(k,j)*eta(j);
      end
   end
   low =  (vLower(k)-mu(k)-etasum)/f(k,k);
   high = (vUpper(k)-mu(k)-etasum)/f(k,k);
   if debug
      low
      high
   end
   
   eta(k) = RandStdNormT(low,high);
   if debug
      eta(k)
   end
 
end
x = mu + f*eta;
